/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
package djbuch.kapitel_05; import java.io.*; import java.net.URLEncoder;
import javax.servlet.http.*; import org.omg.CORBA.ORB; import lotus.domino.*;
/**
 * 
 * @author Thomas Ekert
 *
 */
public class DominoServletConnectionPooling extends HttpServlet {

	static ORB brooker = null;
	static int orbCount = 0;
	private static final int MAX_SESSION_IN_POOL = 10;
	private static final String host = "www.djbuch.de:63148";
	
	public void doGet(HttpServletRequest req, HttpServletResponse resp)
			throws IOException {
		Session session = null;
		if (getToken (req) == null) {
			doRedirect (req, resp);
			return;
		}
		try {
			session = NotesFactory.createSession(host, getBrooker(), req);
			PrintWriter out = resp.getWriter();
			resp.setContentType("text/html"); 
			out.println ("<html><head>\n" +
					"<title>Domino Servlet</title>\n<style>\n" +
					"\tbody {font-family:Helvetica,Arial,sans-serif;}\n" +
					"\th1 {color:#FF00FF;}\n</style>\n</head>\n" +
					"<body>\n<h1>Connection Pooling Servlet</h1>\n");
			out.println("<br/>Name = " + session.getUserName());
			out.println("<br/>Count = " + orbCount);
			out.println("</body></html>");
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			recycleSession(session);
		}
	}

	/**
	 * Falls der Benutzer nicht eingelogt ist, muss er auf die Login-Seite redirected werden.
	 * Damit er danach wieder auf diese Seite zurckkehrt, wird die aktuelle URL
	 * berechnet und als Parameter RedirectTo in der URL bergeben.
	 * Dies funktioniert nur auf einem Domino Server (wg. names.nsf?login)
	 * Auf anderen Servern muss entsprechend dafr gesorgt werden, dass im 
	 * Connection Pooling die Benutzer eingeloggt sind.
	 * @param req
	 * @param resp
	 * @throws IOException
	 */
	private void doRedirect(HttpServletRequest req, HttpServletResponse resp) throws IOException {
		String uri = req.getRequestURI();
		String thisUrl = URLEncoder.encode( (uri==null||uri.equals("")?"":uri+"?") + req.getQueryString());
		resp.sendRedirect("/names.nsf?login&redirectTo="+thisUrl);
	}

	/**
	 * @return - Neuer Object Request Brooker, falls mehr als 10 Sitzungen <br>
	 * offen sind, sonst den bereits erstellten, sofern vorhanden.
	 */
	private static synchronized  ORB getBrooker() {
		orbCount+=1;
		if ((brooker == null) || ((orbCount % MAX_SESSION_IN_POOL) == 0)) {
			brooker = NotesFactory.createORB();
			System.out.println(brooker.getClass() + " wurde erstellt.");
		}
		return brooker;
	}
	
	/**
	 * Das LtpaToken wird vom WebSphere oder Domino Server vergeben <br>
	 * und kann einfach aus den Cookies extrahiert werden.
	 * @param req
	 * @return
	 */
	private String getToken (HttpServletRequest req) {
		Cookie[] cookie = req.getCookies();
		for (int i = 0; cookie != null && i < cookie.length; i++) {
			if (cookie [i].getName().equalsIgnoreCase("LtpaToken")) {
				return cookie [i].getValue();
			}
		}
		return null;
	}
	
	private void recycleSession (Session s) {
		try {
			if (s!= null && s.isValid()) {
				s.recycle ();
			}
		} catch (org.omg.CORBA.INV_OBJREF e) {
			//e.printStackTrace(); //ignore. Server might already have closed DIIOP.
		} catch (NotesException e) {
			e.printStackTrace();
		}
	}
}